% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_metrics.R
\name{cfbd_metrics_wepa_team_season}
\alias{cfbd_metrics_wepa_team_season}
\title{\strong{Get opponent-adjusted team season statistics for predicted points added (PPA)}}
\usage{
cfbd_metrics_wepa_team_season(year = NULL, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_metrics_wepa_team_season]{cfbd_metrics_wepa_team_season()}} - A data frame with 26 variables:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   team_id \tab integer \cr
   team \tab character \cr
   conference \tab character \cr
   explosiveness \tab numeric \cr
   explosiveness_allowed \tab numeric \cr
   epa_total \tab numeric \cr
   epa_passing \tab numeric \cr
   epa_rushing \tab numeric \cr
   epa_allowed_total \tab numeric \cr
   epa_allowed_passing \tab numeric \cr
   epa_allowed_rushing \tab numeric \cr
   success_rate_total \tab numeric \cr
   success_rate_standard_downs \tab numeric \cr
   success_rate_passing_downs \tab numeric \cr
   success_rate_allowed_total \tab numeric \cr
   success_rate_allowed_standard_downs \tab numeric \cr
   success_rate_allowed_passing_downs \tab numeric \cr
   rushing_line_yards \tab numeric \cr
   rushing_second_level_yards \tab numeric \cr
   rushing_open_field_yards \tab numeric \cr
   rushing_highlight_yards \tab numeric \cr
   rushing_allowed_line_yards \tab numeric \cr
   rushing_allowed_second_level_yards \tab numeric \cr
   rushing_allowed_open_field_yards \tab numeric \cr
   rushing_allowed_highlight_yards \tab numeric \cr
}
}
\description{
\strong{Get opponent-adjusted team season statistics for predicted points added (PPA)}
}
\examples{
\donttest{
  try(cfbd_metrics_wepa_team_season(year = 2019, team = "TCU"))
}
}
\seealso{
Other CFBD Metrics: 
\code{\link{cfbd_metrics_fg_ep}()},
\code{\link{cfbd_metrics_ppa_games}()},
\code{\link{cfbd_metrics_ppa_players_games}()},
\code{\link{cfbd_metrics_ppa_players_season}()},
\code{\link{cfbd_metrics_ppa_predicted}()},
\code{\link{cfbd_metrics_ppa_teams}()},
\code{\link{cfbd_metrics_wepa_players_kicking}()},
\code{\link{cfbd_metrics_wepa_players_passing}()},
\code{\link{cfbd_metrics_wepa_players_rushing}()},
\code{\link{cfbd_metrics_wp}()},
\code{\link{cfbd_metrics_wp_pregame}()}
}
\concept{CFBD Metrics}
\keyword{Adjusted}
\keyword{Opponent}
\keyword{Points}
\keyword{Predicted}
\keyword{Team}
