% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_weather}
\alias{cfbd_game_weather}
\title{\strong{Get weather from games.}}
\usage{
cfbd_game_weather(
  year,
  week = NULL,
  season_type = "regular",
  team = NULL,
  conference = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_game_weather]{cfbd_game_weather()}} - A data frame with 23 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week.}
\item{\code{season_type}: character.}{Season type of the game.}
\item{\code{start_date}: character.}{Game date.}
\item{\code{start_time_tbd}: logical.}{TRUE/FALSE flag for if the game's start time is to be determined.}
\item{\code{game_indoors}: logical.}{TRUE/FALSE flag for if the game is indoors}
\item{\code{home_team}: character.}{Home team name.}
\item{\code{home_conference}: character.}{Home team conference.}
\item{\code{away_team}: character.}{Away team name.}
\item{\code{away_conference}: character.}{Away team conference.}
\item{\code{venue_id}: integer.}{Referencing venue id.}
\item{\code{venue}: character.}{Venue name.}
\item{\code{temperature}: integer.}{Temperature.}
\item{\code{dew_point}: integer.}{Dew Point.}
\item{\code{humidity}: integer.}{Humidity.}
\item{\code{precipitation}: integer.}{Precipitation.}
\item{\code{snowfall}: integer.}{Snowfall.}
\item{\code{wind_direction}: integer.}{Wind direction.}
\item{\code{wind_speed}: integer.}{Wind Speed.}
\item{\code{pressure}: integer.}{Pressure.}
\item{\code{weather_condition_code}: integer.}{Weather condition code.}
\item{\code{weather_condition}: character.}{Weather condition.}
}
}
\description{
\strong{Get weather from games.}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_player_stats}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
\keyword{Game}
\keyword{Weather}
