% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs_interview_manual.R
\name{interview_manual}
\alias{interview_manual}
\title{Interview manual of the data collection of Brazil's censuses}
\usage{
interview_manual(
  year = NULL,
  showProgress = TRUE,
  cache = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{year}{Numeric. Year of reference in the format \code{yyyy}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display download progress
bar. The progress bar only reflects only the downloading
time, not the time to load the data to memory.}

\item{cache}{Logical. Whether the function should read the data cached
locally, which is much faster. Defaults to \code{TRUE}. The first time the
user runs the function, \code{censobr} will download the file and store it
locally so that the file only needs to be download once. If \code{FALSE},
the function will download the data again and overwrite the local file.}

\item{verbose}{A logical. Whether the function should print informative
messages. Defaults to \code{TRUE}.}
}
\value{
Opens a \code{.pdf} file on the browser
}
\description{
Open on a browser the interview manual of the data collection of Brazil's
censuses
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Open interview manual on the browser
interview_manual(
  year = 2010,
  showProgress = FALSE
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other Census documentation: 
\code{\link{data_dictionary}()}
}
\concept{Census documentation}
