% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wg2ws_total_age.R
\name{wg2ws_total_age}
\alias{wg2ws_total_age}
\title{Calculate WS total score from WG score.}
\usage{
wg2ws_total_age(WG, age = NA)
}
\arguments{
\item{WG}{Words and Gestures total score.}

\item{age}{Age in months (optional). A different, more accurate model is
used if age is supplied.}
}
\value{
Adjusted score, rounded to the nearest integer. Does not return
values below 0 or greater than 680.
}
\description{
Calculate WS total score from WG score.
}
\details{
Given a single number (WG total score) and optionally age, calculate a WG
score.
}
\examples{

wg2ws_total_age(200)
wg2ws_total_age(200, age = 21)

}
\references{
Day, T. K. M., Borovsky, A., Thal, D., & Elison, J. T. (2025).
Modeling Longitudinal Trajectories of Word Production With the CDI.
\emph{Developmental Science}, 28(4), e70036. \doi{10.1111/desc.70036}
}
