% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{calculate_index}
\alias{calculate_index}
\title{Transform series into index}
\usage{
calculate_index(periods, values, reference_period = NULL)
}
\arguments{
\item{periods}{vector/variable with periods (numeric/string)}

\item{values}{vector/variable with to be transformed values (numeric)}

\item{reference_period}{period or group of periods that will be set to 100 (numeric/string)}
}
\value{
Index series
}
\description{
The index can be calculated in two ways:
\itemize{
\item from a series of values
\item from a series of mutations (from_growth_rate = TRUE)
}
}
\details{
N.B. with from_growth_rate:
The series of mutations must be equally long to the series of values.
The vector should, therefore, also contain a mutation for the first period (this is likely 1).
In the calculation, this first mutation is not used.

N.B. for the reference period:
The first value is on default set to 100.
An adjusted reference period can be provided in the paramater.
The reference period can also be a part of a period.
E.g. if the series contains months (2019jan, 2019feb), the reference period can be a year (2019).
}
\author{
Farley Ishaak
}
\keyword{internal}
