% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teacher.R
\name{teacher_models}
\alias{teacher_models}
\alias{causal_forest}
\alias{rboost}
\alias{rlasso}
\alias{rkern}
\alias{bcf}
\title{Teacher models for causal distillation trees}
\usage{
causal_forest(X, Y, Z, W = NULL, ...)

rboost(X, Y, Z, W = NULL, ...)

rlasso(X, Y, Z, W = NULL, ...)

rkern(X, Y, Z, W = NULL, ...)

bcf(
  X,
  Y,
  Z,
  W = NULL,
  pihat = "default",
  w = NULL,
  nburn = 2000,
  nsim = 1000,
  n_threads = 1,
  no_output = TRUE,
  ...
)
}
\arguments{
\item{X}{A tibble, data.frame, or matrix of covariates.}

\item{Y}{A vector of outcomes.}

\item{Z}{A vector of treatments.}

\item{W}{A vector of weights corresponding to treatment propensities.}

\item{...}{Additional arguments to pass to the base model functions.}

\item{pihat}{Length n estimates of propensity score}

\item{w}{An optional vector of weights. When present, BCF fits a model \eqn{y | x ~ N(f(x), \sigma^2 / w)}, where \eqn{f(x)} is the unknown function.}

\item{nburn}{Number of burn-in MCMC iterations}

\item{nsim}{Number of MCMC iterations to save after burn-in. The chain will run for nsim*nthin iterations after burn-in}

\item{n_threads}{An optional integer of the number of threads to parallelize within chain bcf operations on}

\item{no_output}{logical, whether to suppress writing trees and training log to text files, defaults to FALSE.}
}
\value{
Outputs of the respective base model functions:
\itemize{
\item \code{causal_forest()}: see output of \code{grf::causal_forest()}.
\item \code{rboost()} (defunct): see output of \code{rlearner::rboost()}.
\item \code{rlasso()} (defunct): see output of \code{rlearner::rlasso()}.
\item \code{rkern()} (defunct): see output of \code{rlearner::rkern()}.
}
}
\description{
These functions are wrappers around various heterogeneous treatment effect
learners that can be easily used as
teacher models in the causal distillation tree framework.
\itemize{
\item \code{causal_forest()}: wrapper around \code{grf::causal_forest()}.
\item \code{bcf()}: wrapper around \code{bcf::bcf()}.
\item \code{rboost()}: (defunct) wrapper around \code{rlearner::rboost()}.
\item \code{rlasso()}: (defunct) wrapper around \code{rlearner::rlasso()}.
\item \code{rkern()}: (defunct) wrapper around \code{rlearner::rkern()}.
}

Warning: The \code{rboost()}, \code{rlasso()}, and \code{rkern()} functions
are defunct as of version 1.0.0. Use \code{rlearner_teacher()} (e.g.,
\code{rlearner_teacher(rlearner::rboost)}) instead to convert
\code{rlearner} functions into correct format for use as teacher model in
CDT.
}
\keyword{internal}
