% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student.R
\name{student_rpart}
\alias{student_rpart}
\title{Rpart wrapper for causal distillation trees.}
\usage{
student_rpart(
  X,
  y,
  method = "anova",
  rpart_control = NULL,
  prune = c("none", "min", "1se"),
  fit_only = FALSE
)
}
\arguments{
\item{X}{A tibble, data.frame, or matrix of covariates.}

\item{y}{A vector of responses to predict.}

\item{method}{Same as \code{method} argument in \code{rpart::rpart()}.
Default is \code{"anova"}. See \code{rpart::rpart()} for more details.}

\item{rpart_control}{A list of control parameters for the \code{rpart} algorithm.
See \code{? rpart.control} for details.}

\item{prune}{Method for pruning the tree. Default is \code{"none"}. Options
are \code{"none"}, \code{"min"}, and \code{"1se"}. If \code{"min"}, the
tree is pruned using the complexity threshold which minimizes the
cross-validation error. If \code{"1se"}, the tree is pruned using the
largest complexity threshold which yields a cross-vaidation error within
one standard error of the minimum. If \code{"none"}, the tree is not
pruned.}

\item{fit_only}{Logical. If \code{TRUE}, only the fitted model is returned.
Default is \code{FALSE}.}
}
\value{
If \code{fit_only = TRUE}, the fitted model is returned. Otherwise, a list
with the following components is returned:
\item{fit}{Fitted model. An \code{rpart} model object.}
\item{tree_info}{Data frame with tree structure/split information.}
\item{subgroups}{List of subgroups given by their string representation.}
\item{predictions}{Student model predictions for the given \code{X} data.}
}
\description{
This function is a wrapper around \code{rpart::rpart()} that can be easily
used as a student model in the causal distillation tree framework.
}
