% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{validate_lmm_input}
\alias{validate_lmm_input}
\title{Validate Inputs for Catalytic Linear Mixed Model (LMM)}
\usage{
validate_lmm_input(
  cat_init,
  tau = NULL,
  residual_variance_0 = NULL,
  random_effect_variance_0 = NULL,
  coefs_0 = NULL,
  optimize_domain = NULL,
  max_iter = NULL,
  tol = NULL,
  tau_seq = NULL,
  cross_validation_fold_num = NULL
)
}
\arguments{
\item{cat_init}{An object of class \code{cat_initialization}, typically generated from the \code{cat_lmm_initialization} function.}

\item{tau}{A positive numeric value specifying the penalty parameter for the model.}

\item{residual_variance_0}{A positive numeric value for the initial residual variance estimate.}

\item{random_effect_variance_0}{A positive numeric value for the initial random effect variance estimate.}

\item{coefs_0}{A numeric vector of length equal to the number of columns in the observation matrix. This represents the initial values for the model coefficients.}

\item{optimize_domain}{A numeric vector of length 2 specifying the domain for the optimization procedure.}

\item{max_iter}{A positive integer specifying the maximum number of iterations for the optimization.}

\item{tol}{A positive numeric value indicating the tolerance level for convergence.}

\item{tau_seq}{A numeric vector representing a sequence of values for the penalty parameter.}

\item{cross_validation_fold_num}{A positive integer specifying the number of folds for cross-validation.}
}
\value{
Returns nothing if all checks pass; otherwise, raises an error.
}
\description{
This function validates the parameters needed for fitting a catalytic Linear Mixed Model (LMM) or Generalized Linear Model (GLM),
specifically for the use with the categorical initialization from \code{cat_lmm_initialization}.
}
\details{
This function performs the following checks:
\itemize{
\item Ensures that \code{tau}, \code{tau_seq}, \code{residual_variance_0}, \code{random_effect_variance_0}, \code{optimize_domain}, \code{max_iter}, and \code{tol} are positive values.
\item Verifies that \code{cat_init} is an object generated by \code{cat_lmm_initialization}.
\item Checks if \code{coefs_0} has the same length as the number of columns in the observation matrix of \code{cat_init}.
\item Ensures \code{optimize_domain} is a numeric vector of length 2.
\item Confirms that \code{cross_validation_fold_num} is greater than 1 and less than the number of observations in \code{cat_init}.
If any of these conditions are not met, the function raises an error to guide the user.
}
}
