% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{update_lmm_variance}
\alias{update_lmm_variance}
\title{Calculates the log-likelihood for linear mixed models (LMMs) by combining
observed and synthetic log-likelihoods based on the variance parameters.}
\usage{
update_lmm_variance(
  residual_variance,
  random_effect_variance,
  obs_z_eigenvalues,
  syn_z_eigenvalues,
  obs_adjusted_residuals,
  syn_adjusted_residuals,
  tau
)
}
\arguments{
\item{residual_variance}{Numeric, the variance associated with the residual errors.}

\item{random_effect_variance}{Numeric, the variance associated with random effects.}

\item{obs_z_eigenvalues}{Vector, eigenvalues of the observed Z matrix of data.}

\item{syn_z_eigenvalues}{Vector, eigenvalues of the synthetic Z matrix of data.}

\item{obs_adjusted_residuals}{Vector, adjusted residuals of observed data.}

\item{syn_adjusted_residuals}{Vector, adjusted residuals of synthetic data.}

\item{tau}{Numeric, weight factor for the synthetic data.}
}
\value{
The sum of observed and synthetic log-likelihoods.
}
\description{
This function evaluates the log-likelihood of observed and synthetic data,
using residual and random-effect variance terms to determine the fit
of variance parameters in the mixed model context.
}
