% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{traceplot}
\alias{traceplot}
\title{Traceplot for Bayesian Model Sampling}
\usage{
traceplot(object, ...)
}
\arguments{
\item{object}{An object representing a Bayesian model, typically generated by the
\code{cat_glm_bayes} or \code{cat_cox_bayes} functions, or similar models with Bayesian sampling results.
The function uses S3 method dispatch to apply the appropriate \code{traceplot} method based on
the class of \code{object}.}

\item{...}{Additional arguments passed to specific \code{traceplot} methods for customization, such as
selecting parameters to plot or setting display options.}
}
\value{
A traceplot displaying the MCMC sampling chains for each parameter, assisting in convergence analysis.
The exact output format depends on the specific \code{traceplot} method applied.
}
\description{
The \code{traceplot} function is a generic function used to generate traceplots for Bayesian model sampling,
primarily for assessing the convergence and mixing of Markov Chain Monte Carlo (MCMC) chains. This function
dispatches specific traceplot methods depending on the class of the \code{object} object.
}
\details{
This generic \code{traceplot} function allows for flexible visualization of MCMC chains across
different types of Bayesian models. Specific \code{traceplot} methods, such as \code{traceplot.cat_bayes},
are dispatched based on the \code{object} class to produce tailored traceplots, providing insights
into the sampling progress and convergence diagnostics of each chain.
}
