% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_stan_model}
\alias{get_stan_model}
\title{Generate Stan Model Based on Specified Parameters}
\usage{
get_stan_model(
  type = c("glm", "cox"),
  glm_family_string = c("gaussian", "binomial"),
  joint_tau = FALSE,
  glm_binomial_joint_theta = FALSE,
  glm_binomial_joint_alpha = FALSE,
  glm_gaussian_known_variance = FALSE
)
}
\arguments{
\item{type}{Character, either \code{"glm"} or \code{"cox"}, specifying the type of model to load.}

\item{glm_family_string}{Character, specifying the family for GLM models, either \code{"binomial"} or \code{"gaussian"}.
Required for \code{"glm"} models, ignored for \code{"cox"} models.}

\item{joint_tau}{Logical, if \code{TRUE}, includes "joint" in the file name to indicate a joint model with tau parameter.}

\item{glm_binomial_joint_theta}{Logical, if \code{TRUE} and \code{glm_family_string} is \code{"binomial"}, includes "theta" in the
file name for joint theta parameter.}

\item{glm_binomial_joint_alpha}{Logical, if \code{TRUE} and \code{glm_family_string} is \code{"binomial"}, includes "alpha" in the
file name for joint alpha parameter.}

\item{glm_gaussian_known_variance}{Logical, if \code{TRUE} and \code{glm_family_string} is \code{"gaussian"}, includes
"known_variance" in the file name to specify known variance.}
}
\value{
A compiled Stan model loaded by \code{rstan::stan_model}.
}
\description{
This function retrieves a Stan model file based on a combination of input parameters,
constructs the file path, and loads the Stan model.
}
