% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_glm_log_density_grad}
\alias{get_glm_log_density_grad}
\title{Compute Gradient of Log Density for GLM Families}
\usage{
get_glm_log_density_grad(family_string, X, Y, coefs, weights = 1)
}
\arguments{
\item{family_string}{Character. The GLM family to use. Options are \code{"binomial"} or \code{"gaussian"}.}

\item{X}{Matrix. The design matrix (predictors) for the GLM.}

\item{Y}{Vector. The response variable.}

\item{coefs}{Numeric vector. The coefficients for the GLM.}

\item{weights}{Numeric vector. The weights for the GLM. Default is 1.}
}
\value{
Numeric vector. The gradient of the log density with respect to the coefficients
}
\description{
This function calculates the gradient of the log density with respect to the coefficients
for a given GLM family based on the provided predictors, response variable, and weights.
}
