% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_cox_qr_solve}
\alias{get_cox_qr_solve}
\title{Solve Linear System using QR Decomposition}
\usage{
get_cox_qr_solve(hessian_matrix, gradient_vector)
}
\arguments{
\item{hessian_matrix}{A matrix of coefficients representing the system of linear equations.}

\item{gradient_vector}{A numeric vector representing the constants in the linear system.}
}
\value{
A numeric vector representing the solution to the linear system. NA values in the solution
are replaced with a small value (0.0001). If an error occurs during solving, a vector of default values
(0.0001) is returned.
}
\description{
This function solves the linear system defined by \code{hessian_matrix} and \code{gradient_vector}
using QR decomposition. Any NA values in the resulting solution vector are replaced with 0.0001. If there
is an error during the solution process, a vector of default values (0.0001) is returned instead.
}
