% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_bayes_joint.R
\name{cat_glm_bayes_joint}
\alias{cat_glm_bayes_joint}
\title{Bayesian Estimation for Catalytic Generalized Linear Models (GLMs)  with adaptive tau}
\usage{
cat_glm_bayes_joint(
  formula,
  cat_init,
  chains = 4,
  iter = 2000,
  warmup = 1000,
  algorithm = "NUTS",
  tau_alpha = 2,
  tau_gamma = 1,
  binomial_tau_lower = 0.05,
  binomial_joint_theta = FALSE,
  binomial_joint_alpha = FALSE,
  gaussian_variance_alpha = NULL,
  gaussian_variance_beta = NULL,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables (e.g. \code{~.}).}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{chains}{Number of Markov chains to run. Default is 4.}

\item{iter}{Total number of iterations per chain. Default is 2000.}

\item{warmup}{Number of warm-up iterations per chain (discarded from final analysis). Default is 1000.}

\item{algorithm}{The sampling algorithm to use in \code{rstan::sampling}. Default is "NUTS"
(No-U-Turn Sampler).}

\item{tau_alpha}{Shape parameter of the prior for tau. Default is 2.}

\item{tau_gamma}{Scale parameter of the prior for tau. Default is 1.}

\item{binomial_tau_lower}{A numeric lower bound for tau in Binomial models. Default is 0.05.}

\item{binomial_joint_theta}{Logical; if TRUE, uses joint theta (theta = 1/tau) in Binomial models. Default is FALSE.}

\item{binomial_joint_alpha}{Logical; if TRUE, uses joint alpha (adaptive tau_alpha)
in Binomial models. Default is FALSE. To activate this feature, both
\code{binomial_joint_theta = TRUE} and \code{binomial_joint_alpha = TRUE} must be set.}

\item{gaussian_variance_alpha}{The shape parameter for the inverse-gamma prior on
variance if the variance is unknown in Gaussian models. Defaults to the number of predictors.}

\item{gaussian_variance_beta}{The scale parameter for the inverse-gamma prior on
variance if the variance is unknown in Gaussian models. Defaults to the number of predictors
times variance of observation response.}

\item{...}{Additional parameters to pass to \code{rstan::sampling}.}
}
\value{
A list containing the values of all the arguments and the following components:
\item{stan_data}{A data list used for fitting RStan sampling model.}
\item{stan_model}{Compiled RStan model object for GLMs.}
\item{stan_sample_model}{Fitted RStan sampling model containing posterior samples.}
\item{coefficients}{Mean posterior estimates of model coefficients from \code{stan_sample_model}.}
\item{tau}{Mean posterior of tau (or transformed theta if applicable).}
}
\description{
This function performs Bayesian estimation for a catalytic Generalized Linear Models (GLMs) using RStan
by using adaptive tau. It supports both Gaussian and Binomial family models, enabling
flexibility in prior specifications and algorithm configurations.
}
\examples{
\donttest{
gaussian_data <- data.frame(
  X1 = stats::rnorm(10),
  X2 = stats::rnorm(10),
  Y = stats::rnorm(10)
)

cat_init <- cat_glm_initialization(
  formula = Y ~ 1, # formula for simple model
  data = gaussian_data,
  syn_size = 100, # Synthetic data size
  custom_variance = NULL, # User customized variance value
  gaussian_known_variance = FALSE, # Indicating whether the data variance is unknown
  x_degree = c(1, 1), # Degrees for polynomial expansion of predictors
  resample_only = FALSE, # Whether to perform resampling only
  na_replace = stats::na.omit # How to handle NA values in data
)

cat_model <- cat_glm_bayes_joint(
  formula = ~.,
  cat_init = cat_init, # Only accept object generated from `cat_glm_initialization`
  chains = 1, # Number of Markov chains to be run in the RStan sampling
  iter = 10, # Number of iterations per chain in the RStan sampling
  warmup = 5, # Number of warm-up (or burn-in) iterations for each chain
  algorithm = "NUTS", # Sampling algorithm to use in \code{rstan::sampling}
  tau_alpha = 1, # Shape parameter of the prior for tau
  tau_gamma = 2, # Scale parameter of the prior for tau
  binomial_tau_lower = 0.05, # Lower bound for tau in Binomial models.
  binomial_joint_theta = FALSE, # Indicator for using joint theta for Binomial models
  binomial_joint_alpha = FALSE, # Indicator for using oint alpha for Binomial models
  gaussian_variance_alpha = 1, # The shape parameter for the inverse-gamma prior for variance
  gaussian_variance_beta = 2 # The scale parameter for the inverse-gamma prior for variance
)
cat_model
}
}
