#' DNB gold standard data for computing evaluation metrics
#'
#' A subset of documents found in the catalogue of the DNB with intellectually
#' assigned subject labels from the GND subject vocabulary.
#' The document ids match those in the \code{dnb_test_predictions} dataset.
#'
#' @format ## `dnb_gold_standard`
#' A data.frame with 337 rows and 2 columns:
#' \describe{
#'   \item{\code{doc_id}}{DNB identifier of a document in the catalogue.}
#'   \item{\code{label_id}}{DNB identifier of a concept in the GND subject
#'     vocabulary.}
#' }
"dnb_gold_standard"

#' DNB test predictions for computing evaluation metrics
#'
#' A subset of documents found in the catalogue of the DNB with predictions
#' generated with some arbitrary indexing method. The document ids match those
#' in the \code{dnb_gold_standard} dataset.
#'
#' @format ## `dnb_test_predictions`
#' A data frame with 100,000 rows and 3 columns:
#' \describe{
#'   \item{\code{doc_id}}{DNB identifier of a document in the catalogue.}
#'   \item{\code{label_id}}{DNB identifier of a concept in the GND subject
#'     vocabulary.}
#'   \item{\code{score}}{A confidence score in \eqn{[0, 1]} generated by the
#'     indexing method.}
#' }
"dnb_test_predictions"

#' DNB label distribution for computing propensity scored metrics
#'
#' A subset of labels used in the catalogue of the DNB along with their
#' frequencies of occurrence. The label_ids match those in the
#' \code{dnb_gold_standard} and \code{dnb_test_predictions} datasets.
#'
#' @format ## `dnb_label_distribution`
#' A data frame with 7,772 rows and 3 columns:
#' \describe{
#'   \item{\code{label_id}}{DNB identifier of a concept in the GND subject
#'     vocabulary.}
#'   \item{\code{label_freq}}{Number of occurences of the specified label in the
#'     overall catalogue.}
#'   \item{\code{n_docs}}{Overall number of documents in the ground truth
#'     dataset.}
#' }
"dnb_label_distribution"
