% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_contrast.R
\name{define_contrast}
\alias{define_contrast}
\title{Define a contrast (matrix) to specify exact hypothesis system}
\usage{
define_contrast(type = c("raw", "one", "all"), comparator = NA)
}
\arguments{
\item{type}{(character) \cr either "raw", "one" or "all", see details.}

\item{comparator}{(numeric | character) \cr either integer (index of comparator) or character (name of comparator)}
}
\value{
(\code{cases_contrast}) \cr object to be passed to \code{\link{evaluate}}
}
\description{
Define a contrast (matrix) to specify exact hypothesis system
}
\details{
\itemize{
\item "raw" contrast: compare all candidates against specified benchmark values
\item "one" ('all vs. one' or 'Dunnett') contrast: compare all candidates to a single comparator.
\item "all" ('all vs. all' or 'Tukey') contrast: compare all candidates against each other.
}
}
\examples{
define_contrast("one", 1)
}
