% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/float.R
\name{float}
\alias{float}
\title{Floats}
\usage{
float(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{One of the following,
\itemize{
\item \code{"left"}
\item \code{"l"}
\item \code{"right"}
\item \code{"r"}
\item \code{"none"}

Name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{float()} function places an element to the left or right side of its
parent element. Other text and inline elements wrap around floated elements.
Note, \code{float()} has no effect on flex items.
}
\examples{

library(htmltools)

div(
  div(
    .style \%>\%
      border_color("danger") \%>\%
      float("left"),
    "6.5/10"
  ),
  div(
    "Considering the need for opening sentences.",
    "We may want to reconsider the necessity of second or third sentences.",
    "The whole problem may be avoided by never creating a problem."
  )
)

}
