% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{setargs}
\alias{setargs}
\alias{setallargs}
\title{Set default arguments of a function}
\usage{
setargs(f, ..., setargs.warn = TRUE)
}
\arguments{
\item{f}{function}

\item{...}{arguments to set}

\item{setargs.warn}{cast warning when trying to set default values for
arguments that do not exist in \code{f}}
}
\description{
Sets default values for arguments in \code{f}. Care should be
taken when \code{missing} is used in \code{f} (see examples).
}
\examples{
foo <- function(x, a = 5, ...) {
  foo1 <- function(x, b = 5) return(b)
  c(a = a, b = foo1(x, ...), x = x)
}
foo(1)

f <- setargs(foo, a = 10) # set new default value for a
f(1)

# default value of b in lower-level function is unaffected and warning is
# cast to inform that b is not an argument in f
f <- setargs(foo, b = 10)
f(1)
# disable warning message
setargs(foo, b = 10, setargs.warn = FALSE)(1)

# arguments of lower-level functions can be set with setallargs
f <- setallargs(foo, a = 10, b = 10)
f(1)

# does not work when `missing` checks for missing formal arguments.
foo1 <- function(x, a) {
  if (missing(a)) a <- 5
  return(c(x = x, a = a))
}
f <- setargs(foo1, a = 10)
f(1)
}
\author{
Benedikt Sommer
}
