% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cams_get.R
\name{cams_get_mcclear}
\alias{cams_get_mcclear}
\title{Retrieve McClear clear sky solar radiation data}
\usage{
cams_get_mcclear(lat, lng, date_begin, date_end, time_step = "PT01H",
  alt = -999, verbose = FALSE)
}
\arguments{
\item{lat}{Latitude, in decimal degrees. Required}

\item{lng}{Longitude, in decimal degrees. Required}

\item{date_begin}{Start date as 'yyyy-mm-dd' string. Required}

\item{date_end}{End date as 'yyyy-mm-dd' string. Required}

\item{time_step}{Aggregation: 'PT01M' for minutes, 'PT15M' for 15 minutes,
'PT01H' for hourly, 'P01D' for daily, 'P01M' for monthly. Deafult 'PT01H'}

\item{alt}{Altitude in meters, use -999 to let CAMS decide. Default -99}

\item{verbose}{TRUE for verbose output. Default "FALSE"}
}
\value{
A data frame with requested solar data
}
\description{
Retrieve McClear clear sky solar radiation data
}
\examples{
\dontrun{
df <- cams_get_mcclear(
  lat=60, lng=15, date_begin="2016-01-01", date_end="2016-01-15")
print(head(df))
}

}

