% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-address.R
\name{normal_address}
\alias{normal_address}
\title{Normalize street addresses}
\usage{
normal_address(
  address,
  abbs = NULL,
  na = c("", "NA"),
  punct = "",
  na_rep = FALSE,
  abb_end = TRUE
)
}
\arguments{
\item{address}{A vector of street addresses (ideally without city, state, or
postal code).}

\item{abbs}{A named vector or two-column data frame (like \link{usps_street})
passed to \code{\link[=expand_abbrev]{expand_abbrev()}}. See \code{?expand_abbrev} for the type of object
structure needed.}

\item{na}{A character vector of values to make \code{NA} (like \link{invalid_city}).}

\item{punct}{A character value with which to replace all punctuation.}

\item{na_rep}{logical; If \code{TRUE}, replace all single digit (repeating)
strings with \code{NA}.}

\item{abb_end}{logical; Should only the last word the string be abbreviated
with the \code{abbs} argument? Passed to the \code{end} argument of \code{\link[=str_normal]{str_normal()}}.}
}
\value{
A vector of normalized street addresses.
}
\description{
Return consistent version of a US Street Address using \verb{stringr::str_*()}
functions. Letters are capitalized, punctuation is removed or replaced, and
excess whitespace is trimmed and squished. Optionally, street suffix
abbreviations ("AVE") can be replaced with their long form ("AVENUE").
Invalid addresses from a vector can be removed (possibly using
\link{invalid_city}) as well as single (repeating) character strings ("XXXXXX").
}
\examples{
normal_address("P.O. #123, C/O John Smith", abbs = usps_street)
normal_address("12east 2nd street, #209", abbs = usps_street, abb_end = FALSE)
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
