% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbrev-full.R
\name{abbrev_full}
\alias{abbrev_full}
\title{Abbreviate full strings}
\usage{
abbrev_full(x, full = NULL, rep = NULL, end = FALSE)
}
\arguments{
\item{x}{A vector containing full words.}

\item{full}{One of three objects: (1) A dataframe with full strings in the
\emph{first} column and corresponding abbreviations in the \emph{second}
column; (2) a \emph{named} vector, with full strings as names for their
respective abbreviations (e.g., \code{c("full" = "abb")}); or (3) an unnamed
vector of full words with an unnamed vector of abbreviations in the \code{rep}
argument.}

\item{rep}{If \code{full} is an unnamed vector, a vector of abbreviations strings
for each full word in \code{abb}.}

\item{end}{logical; if \code{TRUE}, then the \code{$} regular expression will be used
to only replace words at the \emph{end} of a string (such as "ROAD" in a street
address). If \code{FALSE} (default), then the \verb{\\b} regular expression will
target \emph{all} instances of \code{full} to be replaced with \code{rep}.}
}
\value{
The vector \code{x} with full words replaced with their abbreviations.
}
\description{
Create or use a named vector (\code{c("full" = "abb")}) and pass it to
\code{\link[stringr:str_replace]{stringr::str_replace_all()}}. The \code{full} argument is surrounded with \verb{\\\\b} to
capture only isolated intended full versions. Note that the built-in
\link{usps_street}, \link{usps_city}, and \link{usps_state} dataframes have the columns
reversed from what this function needs (to work by default with the
counterpart \code{\link[=expand_abbrev]{expand_abbrev()}}).
}
\examples{
abbrev_full("MOUNT VERNON", full = c("MOUNT" = "MT"))
abbrev_full("123 MOUNTAIN ROAD", full = usps_street)
abbrev_full("123 MOUNTAIN ROAD", full = usps_street, end = TRUE)
abbrev_full("Vermont", full = state.name, rep = state.abb)
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{normal_zip}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
