% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_mcr}
\alias{stat_mcr}
\title{Matched callback rates}
\usage{
stat_mcr(x, method = "student", level = 0.95)
}
\arguments{
\item{x}{a \code{callback} object.}

\item{method}{estimation method, "cp" for Clopper-Pearson, "wilson" for Wilson
and "student" for Student (the default).}

\item{level}{the level of the confidence intervals (0.95 by default).}
}
\value{
A list with class \code{"callback_stat"} containing 4 components: specif, 
counts, props and stats 

\code{specif}: A list containing 
\itemize{
  \item\bold{convention:} string "matched callback rates".
  \item\bold{cid:} convention on 3 characters.
  \item\bold{method:} the estimation method, "cp" for Clopper-Pearson, 
  "wilson" for Wilson and "student" for "Student" (the default).
  \item\bold{level:} the level of the confidence intervals (0.95 by default).
  \item\bold{source:} the R stats function used to compute the statistics 
  (binom.test, prop.test or t.test).
  \item\bold{name:} the name of the statistic (Fisher, Pearson or Student).
}

\code{counts}: a data frame with the callback counts.
\itemize{
\item\bold{tests:} number of tests.
\item\bold{callback:} number of tests with at least one callback for either
candidate.
\item\bold{disc:} number of discrimination cases.
\item\bold{c00:} number of test without a callback.
\item\bold{c10:} number of tests with callbacks for candidate 1 only.
\item\bold{c01:} number of tests with callbacks for candidate 2 only.
\item\bold{c11:} number of tests with callbacks for both candidates.
 }

\code{props}: A data frame containing the following proportions and their 
confidence intervals (when relevant)
 \itemize{
  \item\bold{inf_p_callback:} overall callback rate, lower bound.
  \item\bold{p_callback:} overall callback rate.
  \item\bold{sup_p_callback:} overall callback rate, upper bound.
  \item\bold{inf_p_cand1:} 1st candidate callback rate, lower bound.
  \item\bold{p_cand1:} 1st candidate callback rate.
  \item\bold{sup_p_cand1:} 1st candidate callback rate, upper bound.
  \item\bold{inf_p_cand2:} 2nd candidate callback rate, lower bound.
  \item\bold{p_cand2:} 2nd candidate callback rate.
  \item\bold{sup_p_cand2:} 2nd candidate callback rate, upper bound.
  \item\bold{inf_cand_dif:} p_cand1-p_cand2, lower bound.
  \item\bold{p_cand_dif:} callback proportion difference between the candidates.
  \item\bold{sup_cand_dif:} p_cand1-p_cand2, upper bound.
 }

\code{stats}: a data frame containing the statistics for testing the equality 
of proportions.
 \itemize{
  \item\bold{statistic:} the value of the test statistic.
  \item\bold{p_stat:} the p-value of the test statistic.
  \item\bold{c_stat:} the significance code of the test statistic.
   }
}
\description{
Computes the matched callback rates, their confidence intervals and performs
the equality tests between the candidates.
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
str(stat_mcr(x))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Student. (1908). The Probable Error of a Mean. Biometrika, 6(1), 1–25. 
doi:10.2307/2331554.

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
