% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_comp.R
\name{callback_comp}
\alias{callback_comp}
\title{Creates the estimation data for a component model}
\usage{
callback_comp(
  data = NULL,
  cluster = NULL,
  candid = NULL,
  callback = NULL,
  model = NULL
)
}
\arguments{
\item{data}{a data frame.}

\item{cluster}{A variable name, identifying the test (e.g., a job offer number).}

\item{candid}{A list of factor names defining the candidates (e.g., gender, origin).}

\item{callback}{A Boolean variable, equal to TRUE for non negative callbacks.}

\item{model}{a list of string lists, defining the components of the model,
in difference from the reference candidate.}
}
\value{
a list with class \code{callback_comp} containing:
\itemize{
\item\bold{aux_cand: }list of the candidates.
\item\bold{aux_model: }summary of the components model.
\item\bold{aux_boole: }Boole matrix of the components model.
\item\bold{aux_det: }determinant of \code{t(aux_boole)\%*\%aux_boole}.
\item\bold{aux_coef: }auxilliary parameters.
\item\bold{aux_vcov: }covariance matrix of the auxilliary parameters.
\item\bold{aux_cor: }correlation matrix of the auxilliary parameters.
}
}
\description{
Creates the estimation data for a component model
}
\examples{
data(mobility1)
model <- list(c("license"),c("woman"),c("woman","license","inter"))
callback_comp(data = mobility1, cluster = "offer",
candid = c("gender","licenses"), callback = "callback",
model = model)

}
\author{
Emmanuel Duguet
}
