% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_bands.R
\name{calibration_bands}
\alias{calibration_bands}
\title{Confidence bands for monotone probabilities}
\usage{
calibration_bands(
  x,
  y,
  alpha = 0.05,
  method = "standard",
  digits = NULL,
  nc = FALSE
)
}
\arguments{
\item{x}{covariate.}

\item{y}{response variable (in {0,1}).}

\item{alpha}{type one error probability (1 minus the confidence level).}

\item{method}{\code{"standard"} for the original method proposed in the
article, \code{"round"} for rounding the covariate, or \code{"YB"} for the bounds by Yang & Barber
(2019).}

\item{digits}{number of digits for method \code{"round"}. Default is 2.
Has no effect for the other methods.}

\item{nc}{use non-crossing bands for method \code{"standard"} or
\code{"round"}. Has no effect for method \code{"YB"}. Default is
\code{FALSE}. See also \code{"summary(...,iso_test=TRUE)"} in this context.
Crossings allow to reject the null hypothesis of monotonicity in the calibration curve.}
}
\value{
An object of class \code{calibrationband}, which is a list containing the following entries:

\tabular{ll}{
 \code{bands} \tab a tibble holding \code{x,lwr,upr} the lower and upper bound,
 for each value of \code{x}.
 The upper bound extends to the left and the lower bound to the right,
 that is, the upper bound for \code{x[i]<s<x[i+1]} is \code{upr[i+1]},
 and the lower bound for \code{x[i]<s<x[i+1]} is \code{lwr[i]}.\cr
 \code{cal} \tab a tibble holding the areas/segments of calibration (\code{out=0}) and miscalibration (\code{out=1}).  \cr
 \code{bins} \tab a tibble of the characteristics of the isotonic bins. \cr
 \code{cases} \tab tibble of all predictions and observations.
 In addition it holds the column \code{isoy}, which is the isotonic
 regression of \code{y} at points \code{x}.   \cr
 \code{alpha} \tab the given type one error probability (1 minus the nominal
 coverage of the band). \cr
 \code{method} \tab the selected method for computing the band. \cr
\code{nc} \tab the selected method for non-crossing.\cr
\code{digits} \tab the given digits for method \code{"round"}
    (or \code{NULL} for method \code{"standard"}).\cr
 \code{time} \tab time to compute the upper and lower band.
}
}
\description{
Confidence bands for monotone probabilities
}
