% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-main.R
\name{calibrate}
\alias{calibrate}
\alias{calibrate.default}
\title{Sequential parameter estimation for the calibration of complex models}
\usage{
calibrate(
  par,
  fn,
  gr,
  ...,
  method,
  lower,
  upper,
  phases,
  control,
  hessian,
  replicates,
  parallel
)

\method{calibrate}{default}(
  par,
  fn,
  gr = NULL,
  ...,
  method = NULL,
  lower = NULL,
  upper = NULL,
  phases = NULL,
  control = list(),
  hessian = FALSE,
  replicates = 1,
  parallel = FALSE
)
}
\arguments{
\item{par}{A numeric vector or list. The length of the par argument defines the 
number of parameters to be estimated (i.e. the dimension of the problem).}

\item{fn}{The function to be minimized.}

\item{gr}{A function computing the gradient of \code{fn}. If NULL, a numerical approximation
of the gradient is used. It can be also a character specifying the method for the computation
of the numerical gradient: 'central', 'forward' (the default), 'backward' or 'richardson'.}

\item{\dots}{Additional parameters to be passed to \code{fn}.}

\item{method}{The optimization method to be used. The default method
is the AHR-ES (Adaptative Hierarchical Recombination Evolutionary Strategy, 
Oliveros-Ramos & Shin, 2016). See details for the methods available.}

\item{lower}{Lower threshold value(s) for parameters. One value or a vector 
of the same length as par. If one value is provided, it is used for all 
parameters. \code{NA} means \code{-Inf}. By default \code{-Inf} is used (unconstrained).}

\item{upper}{Upper threshold value(s) for parameters. One value or a vector 
of the same length as par. If one value is provided, it is used for all 
parameters. \code{NA} means \code{Inf}. By default \code{Inf} is used (unconstrained).}

\item{phases}{An optional vector of the same length as \code{par}, 
indicating the phase at which each parameter becomes active. If omitted, 
default value is 1 for all parameters, performing a single optimization.}

\item{control}{Parameter for the control of the algorithm itself, see details.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Currently not implemented.}

\item{replicates}{The number of replicates for the evaluation of \code{fn}.
The default value is 1. A value greater than 1 is only useful for stochastic
functions.}

\item{parallel}{Logical. Use parallel computation numerical of gradient?}
}
\description{
This function performs the optimization of a function, possibly 
in sequential phases of increasing complexity, and it is designed for the 
calibration of a model, by minimizing the error function \code{fn} associated to it.
}
\details{
In the control list, \code{aggFn} is a function to aggregate \code{fn} to 
a scalar value if the returned value is a vector. Some optimization algorithm can 
exploite the additional information provided by a vectorial output from \code{fn}.
}
\examples{
calibrate(par=rep(NA, 5), fn=sphereN)
\dontrun{
calibrate(par=rep(NA, 5), fn=sphereN, replicates=3)
calibrate(par=rep(0.5, 5), fn=sphereN, replicates=3, lower=-5, upper=5)
calibrate(par=rep(0.5, 5), fn=sphereN, replicates=3, lower=-5, upper=5, phases=c(1,1,1,2,3))
calibrate(par=rep(0.5, 5), fn=sphereN, replicates=c(1,1,4), lower=-5, upper=5, phases=c(1,1,1,2,3))
}
}
\seealso{
Other optimisers: 
\code{\link{ahres}()},
\code{\link{optim2}()},
\code{\link{optimh}()}
}
\author{
Ricardo Oliveros-Ramos
}
\concept{optimisers}
