% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotPercentileSeries}
\alias{plotPercentileSeries}
\title{Generates a series of plots with number curves by percentile for different models}
\usage{
plotPercentileSeries(
  model,
  start = 1,
  end = NULL,
  group = NULL,
  percentiles = c(0.025, 0.1, 0.25, 0.5, 0.75, 0.9, 0.975),
  filename = NULL
)
}
\arguments{
\item{model}{The Taylor polynomial regression model object from the cNORM}

\item{start}{Number of predictors to start with}

\item{end}{Number of predictors to end with}

\item{group}{The name of the grouping variable; the distinct groups are automatically
determined}

\item{percentiles}{Vector with percentile scores, ranging from 0 to 1 (exclusive)}

\item{filename}{Prefix of the filename. If specified, the plots are saves as
png files in the directory of the workspace, instead of displaying them}
}
\value{
the complete list of plots
}
\description{
This functions makes use of 'plotPercentiles' to generate a series of plots
with different number of predictors. It draws on the information provided by the model object
to determine the bounds of the modeling (age and standard score range). It can be used as an
additional model check to determine the best fitting model. Please have a look at the
' plotPercentiles' function for further information.
}
\examples{
# Load example data set, compute model and plot results
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotPercentileSeries(result, start=4, end=6)

}
\seealso{
plotPercentiles

Other plot: 
\code{\link{compare}()},
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentiles}()},
\code{\link{plotRaw}()},
\code{\link{plotSubset}()}
}
\concept{plot}
