% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stochvol_ocsn2007}
\alias{stochvol_ocsn2007}
\title{Stochastic Volatility}
\usage{
stochvol_ocsn2007(y, h, sigma, h_init, constant)
}
\arguments{
\item{y}{a \eqn{T \times K} matrix containing the time series.}

\item{h}{a \eqn{T \times K} vector of the current draw of log-volatilities.}

\item{sigma}{a \eqn{K \times 1} vector of variances of log-volatilities,
where the \eqn{i}th element corresponds to the \eqn{i}th column in \code{y}.}

\item{h_init}{a \eqn{K \times 1} vector of the initial states of log-volatilities,
where the \eqn{i}th element corresponds to the \eqn{i}th column in \code{y}.}

\item{constant}{a \eqn{K \times 1} vector of constants that should be added to \eqn{y^2}
before taking the natural logarithm. The \eqn{i}th element corresponds to
the \eqn{i}th column in \code{y}. See 'Details'.}
}
\value{
A vector of log-volatility draws.
}
\description{
Produces a draw of log-volatilities based on Omori, Chib, Shephard and Nakajima (2007).
}
\details{
For each column in \code{y} the function produces a posterior
draw of the log-volatility \eqn{h} for the model
\deqn{y_{t} = e^{\frac{1}{2}h_t} \epsilon_{t},}
where \eqn{\epsilon_t \sim N(0, 1)} and \eqn{h_t} is assumed to evolve according to a random walk
\deqn{h_t = h_{t - 1} + u_t,}
with \eqn{u_t \sim N(0, \sigma^2)}.

The implementation follows the algorithm of Omori, Chib, Shephard and Nakajima (2007) and performs the
following steps:
\enumerate{
  \item Perform the transformation \eqn{y_t^* = ln(y_t^2 + constant)}.
  \item Obtain a sample from the ten-component normal mixture for
  approximating the log-\eqn{\chi_1^2} distribution.
  \item Obtain a draw of log-volatilities.
}

The implementation is an adaption of the code provided on the website to the textbook
by Chan, Koop, Poirier, and Tobias (2019).
}
\examples{
data("us_macrodata")
y <- matrix(us_macrodata[, "r"])

# Initialise log-volatilites
h_init <- matrix(log(var(y)))
h <- matrix(rep(h_init, length(y)))

# Obtain draw
stochvol_ocsn2007(y - mean(y), h, matrix(.05), h_init, matrix(0.0001))

}
\references{
Chan, J., Koop, G., Poirier, D. J., & Tobias J. L. (2019). \emph{Bayesian econometric methods}
(2nd ed.). Cambridge: Cambridge University Press.

Omori, Y., Chib, S., Shephard, N., & Nakajima, J. (2007). Stochastic volatiltiy with leverage. Fast and efficient likelihood inference.
\emph{Journal of Econometrics 140}(2), 425--449. \doi{10.1016/j.jeconom.2006.07.008}
}
