% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{set_types}
\alias{set_types}
\alias{get_types}
\alias{get_model}
\title{Define valid types of revenues and expenses}
\usage{
set_types(types, class = c("revenue", "expense"), name = "default")

get_types(
  name = "default",
  class = c("revenue", "expense"),
  names_only = FALSE
)

get_model()
}
\arguments{
\item{types}{Named list,
      one entry for each type. Values define the color to use in plots.}

\item{class}{One of \code{"revenue"} or \code{"expense"}.}

\item{name}{Character string,
      giving the set of types a name. You can use this to have multiple
sets of types simultaneously in the same session.}

\item{names_only}{Logical,
      whether the full list or only the names of defined types should be returned.}
}
\value{
\code{set_types} is a wrapper for \code{\link[base:options]{options}} and adds/replaces a list
   called \code{name} to the \code{businessPlanR} option of the running session.
   \code{get_types} returns the list from the \code{businessPlanR} option.
   \code{get_model} just returns the internal definition of default operations model as a list.
}
\description{
These functions change the globally available options of the running R session.
Its values define types of transactions you want to be able to use in your
business plan.
}
\details{
The getter functions return a list of default types if none have been defined so far.
}
