% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_kable_bpR.R
\docType{methods}
\name{kable_bpR}
\alias{kable_bpR}
\alias{kable_bpR,operations-method}
\alias{kable_bpR,-methods}
\alias{kable_bpR,loan-method}
\alias{kable_bpR,transaction_plan-method}
\title{Format table from condensed objects}
\usage{
kable_bpR(
  obj,
  model = get_model(),
  resolution = c("year", "quarter", "month"),
  keep_types = TRUE,
  detailed = FALSE,
  cashflow = FALSE,
  currency = "€",
  DIY = FALSE,
  longtable_clean_cut = TRUE,
  font_size = NULL,
  latex_options = "striped",
  stripe_color = "gray!6",
  years = get_period(obj, years = TRUE),
  detail_names = c(revenue = "Revenue", expense = "Exepense"),
  detail_colors = c(color = "white", background = "grey"),
  cf_init = 0,
  cf_names = c(begin = "Begin", end = "End"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  detail_width,
  ...
)

\S4method{kable_bpR}{operations}(
  obj,
  model = get_model(),
  resolution = c("year", "quarter", "month"),
  keep_types = TRUE,
  detailed = FALSE,
  cashflow = FALSE,
  currency = "€",
  DIY = FALSE,
  longtable_clean_cut = TRUE,
  font_size = NULL,
  latex_options = "striped",
  stripe_color = "gray!6",
  years = get_period(obj, years = TRUE),
  detail_names = c(revenue = "Revenue", expense = "Exepense"),
  detail_colors = c(color = "white", background = "grey"),
  cf_init = 0,
  cf_names = c(begin = "Begin", end = "End"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  detail_width,
  ...
)

\S4method{kable_bpR}{loan}(
  obj,
  resolution = c("month", "quarter", "year"),
  currency = "€",
  DIY = FALSE,
  font_size = NULL,
  latex_options = "striped",
  stripe_color = "gray!6",
  loan_names = c(balance_start = "Balance start", interest = "Interest", principal =
    "Principal", total = "Total", cumsum = "Cumulated", balance_remain =
    "Balance remain"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  ...
)

\S4method{kable_bpR}{transaction_plan}(
  obj,
  resolution = c("month", "quarter", "year"),
  keep_types = FALSE,
  currency = "€",
  DIY = FALSE,
  longtable_clean_cut = TRUE,
  font_size = NULL,
  latex_options = "basic",
  stripe_color = "gray!6",
  years = get_period(obj, years = TRUE),
  dep_names = c(investment = "Investment", depreciation = "Depreciation", value =
    "Value", sum = "Sum"),
  loan_names = c(balance_start = "Balance start", interest = "Interest", principal =
    "Principal", total = "Total", cumsum = "Cumulated", balance_remain =
    "Balance remain", sum = "Sum"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  zeroes = c(html = "#C0C0C0", latex = "gray!25"),
  ...
)
}
\arguments{
\item{obj}{An object of class \code{\link[businessPlanR:operations-class]{operations}} or \code{\link[businessPlanR:loan-class]{loan}}.}

\item{model}{A named list of named lists describing the stepwise accounting rules
for all data in in \code{obj}.}

\item{resolution}{One of \code{"month"}, \code{"quarter"}, or \code{"year"}.}

\item{keep_types}{Logical,
      whether the returned data frame should keep the intermediate results
for each relevant type of transaction. This will add a column \code{type} to the data frame.}

\item{detailed}{Logical, supersedes \code{keep_types}. If \code{TRUE},
      the table includes detailed
information all the way down to types, categories, and transaction names.}

\item{cashflow}{Logical,
      whether the \code{model} describes a cash flow plan. If \code{TRUE},
calculations will start with the initial value as specified by \code{cf_init} and use the
result of each period as the starting value of following periods. This only works if \code{detailed=FALSE}.}

\item{currency}{Character defining a currency symbol.}

\item{DIY}{Logical,
      if \code{TRUE} returns the \code{kable} object prior to any row collapsing, column specs or kable styling,
so you can apply all of those as you wish.}

\item{longtable_clean_cut}{Passed to \code{\link[kableExtra:collapse_rows]{collapse_rows}}.}

\item{font_size}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{latex_options}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{stripe_color}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{years}{Character (or numeric) vector defining the year(s) to be represented in the output. This is intended to be
useful for splitting up quarterly or monthly output.}

\item{detail_names}{A named character vector with two entries,
      \code{revenue} and \code{expense},
defining the global names used for the two transaction classes in the data frame if \code{detailed=TRUE}.}

\item{detail_colors}{A named character vector with two entries,
      \code{color} and \code{background}, defining the color scheme
for position headlines (revenue and expense). Only relevant if \code{detailed=TRUE}.}

\item{cf_init}{Numeric,
      used as the initial value for cash flow calculations if \code{cashflow=TRUE}; i.e.,
the first beginning cash value.}

\item{cf_names}{Character vector with two entries named \code{begin} and \code{end},
      used in the resulting
table for beginning cash and ending cash.}

\item{space}{Character, a space definition to put between currency and value.}

\item{detail_width}{Optional vector of length 3,
      if given defined the width of the three categorial columns,
\code{Type}, \code{Category}, and \code{Name}.}

\item{...}{Additional arguments passed on to \code{\link[kableExtra:kbl]{kbl}}.}

\item{loan_names}{Like \code{dep_names} but with seven named entries,
      \code{balance_start}, \code{interest},
\code{principal}, \code{total}, \code{cumsum}, \code{balance_remain}, and \code{sum},
      for loan plans, respectively.}

\item{dep_names}{A named character vector with four entries, \code{investment},
      \code{depreciation}, \code{value},
and \code{sum}, used in table to describe the rows of each depreciation item,
      with \code{sum} only being used
in the final set of rows showing a summary over all items.}

\item{zeroes}{Named character vector defining the text color to use for zero amounts,
      for both LaTeX and HTML format.}
}
\value{
An object of class \code{kable}.
}
\description{
This method uses the \code{kableExtra} package for table formatting.
}
