% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmqControl.R
\name{clmqControl}
\alias{clmqControl}
\title{Control of marginal HR estimation via clustermq}
\usage{
clmqControl(
  memory = 1024 * 32,
  local_se = FALSE,
  clmq_se = FALSE,
  clmq_hr = TRUE,
  clmq_local = FALSE,
  n_jobs = 100,
  local_cores = 1
)
}
\arguments{
\item{memory}{Numeric. Memory allocation for the remote workers.}

\item{local_se}{Bool. True for calculating SE using local multiprocess in remote workers. This is only useful when clmq_se = TRUE.}

\item{clmq_se}{Bool. True for using parallel computation (nested or local) via clustermq. This can be combined with local_se to calculate SE with nested parallel computation or local multiprocess. Nested parallel computation means double parallel computations -- each worker will do a parallel computation for \link[bunsen]{simulate_counterfactuals}. False for calculating SE only in remote workers without nested parallel computation and local multiprocess.}

\item{clmq_hr}{Bool. True for calculating point estimate (marginal HR) using parallel computation via clustermq.}

\item{clmq_local}{Bool. True for calculating point estimate (marginal HR) using local multiprocess in remote workers. This is only useful when clmq_hr = TRUE.}

\item{n_jobs}{Numeric. Number of remote workers via clustermq.}

\item{local_cores}{Numeric. Number of cores or processes used in local multiprocess. This is only useful when local_se or clmq_local = TRUE.}
}
\value{
A list containing the control arguments.
}
\description{
Construct control structures for marginal HR estimation. Specifically, this is the control for parallel computation via clustermq. It provides the nested parallel computation via LSF (remote parallel computation within remote parallel computation) and local multiprocess within remote parallel computation.
}
\details{
The control function provides options to set the memory of each remote node, number of cpus used by each remote node, and computation approach (whether or not use the nested parallel computation or local multiprocess with parallel computation).
}
\examples{
\dontrun{
#Don't run as it requires LSF scheduler

library(survival)
data("oak")

cox_event <- coxph(Surv(OS, os.status) ~ trt + btmb + pdl1, data = oak)

cox_censor <- coxph(Surv(OS, 1 - os.status) ~ trt + btmb + pdl1, data = oak)


get_marginal_effect(
  trt = "trt", cox_event = cox_event, cox_censor = cox_censor, SE = TRUE,
  M = 1000, n.boot = 10, data = oak, seed = 1, cpp = FALSE, control = clmqControl()
)


}
}
