% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticity.R
\name{elasticity}
\alias{elasticity}
\title{Elasticity}
\usage{
elasticity(
  beta,
  binwidth,
  zstar,
  t0,
  t1,
  notch = FALSE,
  e_parametric = FALSE,
  e_parametric_lb = 1e-04,
  e_parametric_ub = 3
)
}
\arguments{
\item{beta}{normalized excess mass.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{zstar}{a numeric value for the the bunching point.}

\item{t0}{numeric value setting the marginal (average) tax rate below zstar in a kink (notch) setting.}

\item{t1}{numeric value setting the marginal (average) tax rate above zstar in a kink (notch) setting.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{e_parametric}{whether to estimate elasticity using parametric specification (quasi-linear and iso-elastic utility function). Default is FALSE (which estimates reduced-form approximation).}

\item{e_parametric_lb}{lower bound for elasticity estimate's solution using parametric specification in notch setting. Default is 1e-04.}

\item{e_parametric_ub}{upper bound for elasticity estimate's solution using parametric specification in notch setting. Default is 3.}
}
\value{
\code{elasticity} returns the estimated elasticity. By default, this is based on the reduced-form approximation. To use the parametric equivalent, set e_parametric to TRUE.
}
\description{
Estimate elasticity from single normalized bunching observation.
}
\examples{
elasticity(beta = 2, binwidth = 50, zstar = 10000, t0 = 0, t1 = 0.2)

}
\seealso{
\code{\link{bunchit}}
}
