% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4ProgressBar}
\alias{bs4ProgressBar}
\alias{bs4MultiProgressBar}
\alias{progressBar}
\alias{multiProgressBar}
\title{AdminLTE3 progress bar}
\usage{
bs4ProgressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  animated = FALSE,
  status = "primary",
  size = NULL,
  label = NULL
)

bs4MultiProgressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  animated = FALSE,
  status = "primary",
  size = NULL,
  label = NULL
)

progressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  animated = FALSE,
  status = "primary",
  size = NULL,
  label = NULL
)

multiProgressBar(
  value,
  min = 0,
  max = 100,
  vertical = FALSE,
  striped = FALSE,
  animated = FALSE,
  status = "primary",
  size = NULL,
  label = NULL
)
}
\arguments{
\item{value}{Progress bar value.}

\item{min}{Progress bar minimum value.}

\item{max}{Progress bar maximum value.}

\item{vertical}{Whether to display the progress bar in vertical mode. FALSE by default.}

\item{striped}{Whether the progress bar is striped or not. FALSE by default.}

\item{animated}{Whether to animate the progress bar. Default to FALSE.}

\item{status}{Progress bar status. Valid colors are defined as follows:
\itemize{
\item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
\item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
\item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
\item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
\item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
\item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
\item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
\item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
\item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
\item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
\item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
\item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
\item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
\item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
\item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
\item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
\item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
\item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
\item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
\item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{size}{Progress bar size. NULL, "sm", "xs" or "xxs".}

\item{label}{Progress label. NULL by default.}
}
\description{
Create a Bootstrap 4 progress bar.
}
\details{
For \code{multiProgressBar()}, \code{value} can be a vector which
corresponds to the progress for each segment within the progress bar.
If supplied, \code{striped}, \code{animated}, \code{status}, and \code{label} must be the
same length as \code{value} or length 1, in which case vector recycling is
used.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      box(
       title = "Horizontal",
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE
       ),
       progressBar(
        value = 50,
        status = "warning",
        size = "xs"
       ),
       progressBar(
        value = 20,
        status = "danger",
        size = "sm"
       ),
       multiProgressBar(
        value = c(50, 20),
        status = c("warning", "danger"),
        size = "sm"
       )
      ),
      box(
       title = "Vertical",
       progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE,
        vertical = TRUE
       ),
       progressBar(
        value = 50,
        status = "warning",
        size = "xs",
        vertical = TRUE
       ),
       progressBar(
        value = 20,
        status = "danger",
        size = "sm",
        vertical = TRUE
       ),
       multiProgressBar(
        value = c(50, 20),
        status = c("warning", "danger"),
        size = "sm",
        vertical = TRUE
       )
      )
     ),
     title = "Progress bars"
   ),
   server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
