% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_prior_archetype.R
\name{brm_prior_archetype}
\alias{brm_prior_archetype}
\title{Informative priors for fixed effects in archetypes}
\usage{
brm_prior_archetype(label, archetype)
}
\arguments{
\item{label}{A data frame with one row per model parameter in the
archetype and columns to indicate the mapping between priors
and labels. Generate using \code{\link[=brm_prior_label]{brm_prior_label()}} or manually.
See the examples and the informative prior archetypes vignette
for details.}

\item{archetype}{An informative prior archetype generated by a function
like \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.}
}
\value{
A \code{brms} prior object that you can supply to the \code{prior}
argument of \code{\link[=brm_model]{brm_model()}}.
}
\description{
Create a \code{brms} prior for fixed effects in an archetype.
}
\section{Prior labeling}{

Informative prior archetypes use a labeling scheme to assign priors
to fixed effects. How it works:

\if{html}{\out{<div class="sourceCode">}}\preformatted{1. First, assign the prior of each parameter a collection
  of labels from the data. This can be done manually or with
  successive calls to [brm_prior_label()].
2. Supply the labeling scheme to [brm_prior_archetype()].
  [brm_prior_archetype()] uses attributes of the archetype
  to map labeled priors to their rightful parameters in the model.
}\if{html}{\out{</div>}}

For informative prior archetypes, this process is much more convenient
and robust than manually calling \code{\link[brms:set_prior]{brms::set_prior()}}.
However, it requires an understanding of how the labels of the priors
map to parameters in the model. This mapping varies from archetype
to archetype, and it is documented in the help pages of
archetype-specific functions such as \code{\link[=brm_archetype_successive_cells]{brm_archetype_successive_cells()}}.
}

\examples{
set.seed(0L)
data <- brm_simulate_outline(
  n_group = 2,
  n_patient = 100,
  n_time = 3,
  rate_dropout = 0,
  rate_lapse = 0
) |>
  dplyr::mutate(response = rnorm(n = dplyr::n())) |>
  brm_simulate_continuous(names = c("biomarker1", "biomarker2")) |>
  brm_simulate_categorical(
    names = c("status1", "status2"),
    levels = c("present", "absent")
  )
archetype <- brm_archetype_successive_cells(data)
dplyr::distinct(data, group, time)
prior <- NULL |>
  brm_prior_label("normal(1, 1)", group = "group_1", time = "time_1") |>
  brm_prior_label("normal(1, 2)", group = "group_1", time = "time_2") |>
  brm_prior_label("normal(1, 3)", group = "group_1", time = "time_3") |>
  brm_prior_label("normal(2, 1)", group = "group_2", time = "time_1") |>
  brm_prior_label("normal(2, 2)", group = "group_2", time = "time_2") |>
  brm_prior_label("normal(2, 3)", group = "group_2", time = "time_3") |>
  brm_prior_archetype(archetype = archetype)
prior
class(prior)
}
\seealso{
Other priors: 
\code{\link{brm_prior_label}()},
\code{\link{brm_prior_simple}()},
\code{\link{brm_prior_template}()}
}
\concept{priors}
