% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nii2RData.R
\name{nii2RData}
\alias{nii2RData}
\title{Read NIfTI Image(s) File(s) into R data}
\usage{
nii2RData(niiFile1, resolution = "2mm", saveName = "None",
  regionCode = "", niiFile2 = "", imgPath = getwd(), datPath = getwd())
}
\arguments{
\item{niiFile1}{the NIfTI data file(s) (containing information of fMRI of patient(s))
you would like to use. If you want to read more than one file, you can either type in the name in
the form of vector string, or call this function for several times.}

\item{resolution}{the resolution of your region data. It can take "2mm" as default.
If user would like to use 3mm resolution, type in "3mm".}

\item{saveName}{whether to save processed imaging data.
If you do not have enough space or do not want to use space to store processed data,
just type in "None" (default); otherwise you need to specify name in this argument.
For example, saveName="myName.RData".}

\item{regionCode}{the region code provided by user or default.
It should have 3 columns with index, region code and region name.}

\item{niiFile2}{the NIfTI region file you would like to use. It has default NIfTI file
and can be left as blank if no region file provided.}

\item{imgPath}{the directory where your NIfTI file(s) is (are) located.
It chooses your current working directory as default.}

\item{datPath}{the directory where you would like to store .RData file(s).
It chooses your current working directory as default.}
}
\value{
the processed imaging data.
}
\description{
This function can take NIfTI data file(s) (the file extension is "nii.gz" or "nii") as input
(you only need to specify the name of file before extension) and transform them
into RData file(s) (in the form of .RData).
}
\details{
This function must accept the NIfTI imaging data as argument to manipulate
the raw data to processed R data. The file extension is "nii.gz" or "nii".
You only need to specify the name of file without extension in the function argument.
For example, your interested imaging file is called "brain.nii.gz" or "brain.nii".
You only need to write niiFile1="brain" in the first argument rather than "brain.nii.gz"
or something else. The package can either use its default region code and region data
or use user-defined region information. \cr
Here are some notes which may be useful: \cr
(1) When reading multiple imaging files, make sure they have the same resolution,
region code and region data.
(2) If you would like to read multiple imaging files, and if you did not use
saveName="None" argument, it can sometimes take a large storage. For example,
if you read 100 files, then 100 "RData" files will be generated and thus take
a large storage space. Thus, saveName="None" is highly recommended in this case.
}
\examples{
\donttest{
#It will take more than 10 s to run
#write data into temp file
filePath <- tempdir()
#the nii.gz fMRI imaging file is created (toy example)
oro.nifti::writeNIfTI(brainKCCA::input_img, paste(filePath, "/",  "temp", sep=""))
#read fMRI data
testcase1 <- nii2RData(niiFile1 = "temp", resolution = "3mm", imgPath = filePath)
}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
