% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PosteriorFEVDPANEL}
\alias{plot.PosteriorFEVDPANEL}
\title{Plots forecast error variance decompositions}
\usage{
\method{plot}{PosteriorFEVDPANEL}(
  x,
  which_c,
  cols,
  main,
  xlab,
  mar.multi = c(1, 4.6, 0, 4.6),
  oma.multi = c(6, 0, 5, 0),
  ...
)
}
\arguments{
\item{x}{an object of class \code{PosteriorFEVDPANEL} obtained using the
\code{compute_variance_decompositions()} function containing posterior draws of 
forecast error variance decompositions.}

\item{which_c}{a positive integer or a character string specifying the country 
for which the forecast should be plotted.}

\item{cols}{an \code{N}-vector with colours of the plot}

\item{main}{an alternative main title for the plot}

\item{xlab}{an alternative x-axis label for the plot}

\item{mar.multi}{the default \code{mar} argument setting in \code{graphics::par}. Modify with care!}

\item{oma.multi}{the default \code{oma} argument setting in \code{graphics::par}. Modify with care!}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Plots of the posterior means of the forecast error variance 
decompositions.
}
\seealso{
\code{\link{compute_variance_decompositions.PosteriorBVARPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}

set.seed(123)
specification  = specify_bvarPANEL$new(ilo_dynamic_panel[1:5])

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute forecast error variance decomposition 4 years ahead
fevd           = compute_variance_decompositions(posterior, horizon = 4)
plot(fevd, which_c = "ARG")
}
