% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_two_groups.R
\name{compare_two_groups}
\alias{compare_two_groups}
\title{Compare Two Groups with Boxplot and Significance Test}
\usage{
compare_two_groups(data, continuous, group)
}
\arguments{
\item{data}{A data.frame containing the variables.}

\item{continuous}{Name of continuous variable (string).}

\item{group}{Name of categorical variable with exactly 2 levels (string).}
}
\value{
A list containing:
\describe{
\item{plot}{A ggplot object of the boxplot with jittered points.}
\item{normality}{A data.frame showing Shapiro-Wilk test results by group.}
\item{test_summary}{A data.frame summarizing the statistical test used, statistic, df (if applicable), and p-value.}
}
}
\description{
Generates side-by-side boxplots and runs Shapiro-Wilk tests by group
to check for normality. If both groups are normally distributed,
an independent two-sample t-test is applied. Otherwise,
a Mann–Whitney U test (Wilcoxon rank-sum test) is performed.
Returns a structured list with plots and a clear test summary.
}
\examples{
res <- compare_two_groups(mtcars, "mpg", "am")
res$plot
res$normality
res$test_summary
}
