% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.boostrq}
\alias{predict.boostrq}
\title{Model predictions for boosting regression quantiles}
\usage{
\method{predict}{boostrq}(object, newdata = NULL, which = NULL, aggregate = "sum", ...)
}
\arguments{
\item{object}{a boostrq object}

\item{newdata}{a data.frame (or data.table) including all covariates contained in the
baselearners}

\item{which}{a subset of base-learners}

\item{aggregate}{a character specifying how to aggregate coefficients of
single base learners. The default returns the coefficient for the final number
of boosting iterations. "cumsum" returns a list with matrices (one per base-learner)
with the cumulative coefficients for all iterations. "none" returns a list of
matrices where the jth columns of the respective matrix contains coefficients
of the base-learner of the jth boosting iteration.}

\item{...}{additional arguments passed to callies}
}
\value{
predictions for the new data
}
\description{
Model predictions for boosting regression quantiles
}
\examples{
boosted.rq <-
boostrq(
 formula = mpg ~ brq(cyl * hp) + brq(am + wt),
 data = mtcars,
 mstop = 200,
 nu = 0.1,
 tau = 0.5
)

predict.data <- data.frame(hp = 165, cyl = 6, am = 1, wt = 3.125)

predict(boosted.rq, newdata = predict.data)

}
