% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyModels.R
\name{DDF}
\alias{DDF}
\title{Linear programming model for Directional Distance Function measure}
\usage{
DDF(
  data,
  x,
  y,
  dataOriginal = data,
  xOriginal = x,
  yOriginal = y,
  FDH = FALSE,
  direction.vector
)
}
\arguments{
\item{data}{\code{data.frame} or \code{matrix} containing the new variables
in the model.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{dataOriginal}{\code{data.frame} or \code{matrix} containing the
original
variables used to create the model.}

\item{xOriginal}{Vector. Column input indexes in original data.}

\item{yOriginal}{Vector. Column output indexes in original data.}

\item{FDH}{Binary decision variables}

\item{direction.vector}{Direction vector. Valid values are: \code{dmu} (x_0, y_0),
\code{unit} (unit vector), \code{mean} (mean values of each variable) and
a user specific vector of the same length as the number of input and output
variables}
}
\value{
\code{matrix} with the the predicted score
}
\description{
This function predicts the expected output through a DEA model.
}
