% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student.R
\name{Student}
\alias{Student}
\title{Non-central Student distribution}
\description{
A R6 class to represent a non-central Student distribution.
}
\note{
The non-centrality parameter of the Student distribution in the
  \strong{stats} package is limited to \code{abs(ncp) <= 37.62}.
  The present implementation allows a larger range.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nu}}{Get or set the value of \code{nu}.}

\item{\code{delta}}{Get or set the value of \code{delta}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Student-new}{\code{Student$new()}}
\item \href{#method-Student-d}{\code{Student$d()}}
\item \href{#method-Student-p}{\code{Student$p()}}
\item \href{#method-Student-q}{\code{Student$q()}}
\item \href{#method-Student-r}{\code{Student$r()}}
\item \href{#method-Student-mean}{\code{Student$mean()}}
\item \href{#method-Student-median}{\code{Student$median()}}
\item \href{#method-Student-mode}{\code{Student$mode()}}
\item \href{#method-Student-sd}{\code{Student$sd()}}
\item \href{#method-Student-variance}{\code{Student$variance()}}
\item \href{#method-Student-skewness}{\code{Student$skewness()}}
\item \href{#method-Student-kurtosis}{\code{Student$kurtosis()}}
\item \href{#method-Student-kurtosisExcess}{\code{Student$kurtosisExcess()}}
\item \href{#method-Student-clone}{\code{Student$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-new"></a>}}
\if{latex}{\out{\hypertarget{method-Student-new}{}}}
\subsection{Method \code{new()}}{
New Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$new(nu, delta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nu}}{degrees of freedom parameter, \code{>0}}

\item{\code{delta}}{non-centrality parameter}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Student} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-d"></a>}}
\if{latex}{\out{\hypertarget{method-Student-d}{}}}
\subsection{Method \code{d()}}{
Density function of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$d(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{numeric vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The density evaluated at \code{x}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-p"></a>}}
\if{latex}{\out{\hypertarget{method-Student-p}{}}}
\subsection{Method \code{p()}}{
Cumulative distribution function of the Student
  distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$p(q, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{numeric vector of quantiles}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cumulative probabilities corresponding to \code{q}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-q"></a>}}
\if{latex}{\out{\hypertarget{method-Student-q}{}}}
\subsection{Method \code{q()}}{
Quantile function of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$q(p, lower = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{numeric vector of probabilities}

\item{\code{lower}}{Boolean, whether to deal with the lower tail}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The quantiles corresponding to \code{p}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-r"></a>}}
\if{latex}{\out{\hypertarget{method-Student-r}{}}}
\subsection{Method \code{r()}}{
Sampling from the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$r(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{number of simulations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric vector of length \code{n}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-mean"></a>}}
\if{latex}{\out{\hypertarget{method-Student-mean}{}}}
\subsection{Method \code{mean()}}{
Mean of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$mean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mean of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-median"></a>}}
\if{latex}{\out{\hypertarget{method-Student-median}{}}}
\subsection{Method \code{median()}}{
Median of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$median()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The median of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-mode"></a>}}
\if{latex}{\out{\hypertarget{method-Student-mode}{}}}
\subsection{Method \code{mode()}}{
Mode of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$mode()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The mode of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-sd"></a>}}
\if{latex}{\out{\hypertarget{method-Student-sd}{}}}
\subsection{Method \code{sd()}}{
Standard deviation of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$sd()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The standard deviation of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-variance"></a>}}
\if{latex}{\out{\hypertarget{method-Student-variance}{}}}
\subsection{Method \code{variance()}}{
Variance of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$variance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The variance of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-skewness"></a>}}
\if{latex}{\out{\hypertarget{method-Student-skewness}{}}}
\subsection{Method \code{skewness()}}{
Skewness of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$skewness()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The skewness of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-kurtosis"></a>}}
\if{latex}{\out{\hypertarget{method-Student-kurtosis}{}}}
\subsection{Method \code{kurtosis()}}{
Kurtosis of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$kurtosis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-kurtosisExcess"></a>}}
\if{latex}{\out{\hypertarget{method-Student-kurtosisExcess}{}}}
\subsection{Method \code{kurtosisExcess()}}{
Kurtosis excess of the Student distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$kurtosisExcess()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The kurtosis excess of the Student distribution.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Student-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Student-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Student$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
