% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_fdb.R
\name{func_fdb}
\alias{func_fdb}
\title{Functional Bootstrap in the Frequency Domain (FDB)}
\usage{
func_fdb(
  x,
  B,
  kernel = "normal",
  bandwidth,
  p = 0.5,
  PLT = c("spec", "cdf", NULL)
)
}
\arguments{
\item{x}{A vector or time series.}

\item{B}{A positive integer; the number of bootstrap replications.}

\item{kernel}{A character string specifying the smoothing kernel. The valid values
are:
\itemize{
\item \code{"normal"} - default,
\item \code{"epanechnikov"},
\item \code{"box"} - rectangular kernel.
}}

\item{bandwidth}{A real number; the kernel bandwidth smoothing parameter.
If unspecified, an optimal value is computed using formula \eqn{sd(x)*n^(-1/3)},
which is smaller than the Silverman's rule-of-thumb bandwidth.}

\item{p}{A vector of the quantiles to be calculated. Default is \code{p = 0.5}.}

\item{PLT}{An argument specifying what to plot:
\itemize{
\item \code{"spec"} - spectral density,
\item \code{"cdf"} - cumulative distribution,
\item \code{NULL} - no plots - default.
}}
}
\value{
The function returns a list of two components:
\enumerate{
\item The boodd object:
\itemize{
\item \code{s}: A matrix of size \eqn{B \times (2n_0 + l_p)}, where
\eqn{n_0 = \lfloor n/2 \rfloor} and \eqn{l_p} is the length of vector \code{p}.
The first \eqn{n_0} columns contain bootstrap values of the spectral density
at the frequency \eqn{2\pi n_0}. The columns \eqn{n_0+1} up to \eqn{2n_0} contain values
of the cumulative distribution function corresponding to the bootstrap spectral density,
and the last \eqn{l_p} columns contain the estimated quantiles.
\item \code{Tn}: Estimated values of the spectral density, the estimated cumulative
distribution of the spectral density, and the quantiles.
}
\item \code{freqs}: The vector of frequencies at which the functionals are computed
for the process \code{x}.
}
}
\description{
Uses the Frequency Domain Bootstrap (FDB) to compute the bootstrap
spectral density, cumulative distribution function for the estimated spectral
density, and the quantiles of the standardized distribution.
}
\details{
The function performs a bootstrap in the frequency domain and computes
the specified functionals. It estimates the spectral density using
a periodogram smoothed by the specified kernel and bandwidth. The function then
computes the cumulative spectral density and quantiles based on this estimation.
}
\examples{
\donttest{
# Choice of sample size 
n <- 1000
# Simulate AR(1) model with parameter 0.6
 x <- arima.sim(list(order=c(1,0,0),ar=0.6),n=n)
 n0=floor(n/2)
 bf=func_fdb(x,199, PLT="spec")
 }
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and  Dudek, A.E. (2021). Consistency of the Frequency Domain
Bootstrap for differentiable functionals, \emph{Electron. J. Statist.}, \bold{15}, 1-36.

Hurvich, C. M. and Zeger, S. L. (1987). Frequency domain bootstrap
methods for time series, Technical Report 87-115, Graduate School of Business
Administration, New York Univ.

Lahiri, S.N. (2003). \emph{Resampling Methods for Dependent Data}. Springer,
New York.
}
\seealso{
\code{\link{aidedboot}},\code{\link{tft_boot}}, \code{\link{aidedboot}},
\code{\link{freqboot}}, \code{\link{per_boo}}.
}
\keyword{"Frequency}
\keyword{"Spectral}
\keyword{"Time}
\keyword{Bootstrap"}
\keyword{Domain}
\keyword{analysis"}
\keyword{series"}
