#' Package boodd: bootstrap for dependent data
#'
#' The package \code{boodd} contains functions, datasets and examples to
#' accompany the textbook by Patrice Bertail and Anna Dudek (2025),
#' *Bootstrap for Dependent Data, with an R package (by Bernard Desgraupes and Karolina Marek)* – submitted.
#'
#' @details
#' \tabular{ll}{
#' Version: \tab \Sexpr[stage=render]{library(utils); packageVersion("boodd")}\cr
#' Date: \tab \Sexpr[stage=build]{format(Sys.time(), "%Y-%m-%d")}\cr
#' License: \tab \Sexpr[stage=build]{library(utils); packageDescription("boodd")$License}\cr
#' }
#'
#' A list of functions:
#'
#' \itemize{
#'   \item \code{\link{boots}} – Bootstrap in the i.i.d. case.
#'   \item \code{\link{bootsemi}} – Semi-parametric bootstrap for time series.
#'   \item \code{\link{blockboot}} – Block bootstrap for stationary time series.
#'   \item \code{\link{regenboot}} – Regenerative Bootstrap.
#'   \item \code{\link{findBestEpsilon}} – Calculating the optimal value of the epsilon.
#'   \item \code{\link{aidedboot}} – Aided Frequency Bootstrap.
#'   \item \code{\link{b.star}} – Optimal length of bootstrap blocks.
#'   \item \code{\link{boodd}} – Package overview: bootstrap for dependent data.
#'   \item \code{\link{bootglm}} – Bootstrap for Generalized Linear Model.
#'   \item \code{\link{boot_dist}} – Bootstrap distribution.
#'   \item \code{\link{confint.boodd}} – Confidence intervals for objects of class boodd.
#'   \item \code{\link{class.boodd}} – Objects of class boodd.
#'   \item \code{\link{embb}} – Characteristics for Extended Moving Block Bootstrap class.
#'   \item \code{\link{embb.sample}} – EMBB method.
#'   \item \code{\link{fieldboot}} – Random Field Bootstrap.
#'   \item \code{\link{field.sub}} – Field subsampling.
#'   \item \code{\link{freqboot}} – Frequency Domain Bootstrap.
#'   \item \code{\link{jackFunc}} – Create a function that calculates the statistic and the jackknife variance.
#'   \item \code{\link{jackVar}} – Jackknife Variance for statistics based on i.i.d data.
#'   \item \code{\link{jackVarBlock}} – Jackknife Variance for blocks.
#'   \item \code{\link{jackVarRegen}} – Jackknife Variance for regenerative processes.
#'   \item \code{\link{jackVarRegen.atom}} – Jackknife Variance for finite states Markov chains.
#'   \item \code{\link{jackVarRegen.smallEnsemble}} – Jackknife Variance for homogeneous Markov chains.
#'   \item \code{\link{jackFuncBlock}} – Jackknife Function for blocks.
#'   \item \code{\link{jackFuncRegen}} – Jackknife Function in regenerative case.
#'   \item \code{\link{jackVarField}} – Jackknife Variance for random fields.
#'   \item \code{\link{lam}} – Lag window.
#'   \item \code{\link{plot.boodd}} – Plot objects of class boodd.
#'   \item \code{\link{qVar}} – Variance estimator for quantile.
#'   \item \code{\link{seasonalMean}} – Characteristics of periodically correlated time series.
#'   \item \code{\link{sieveboot}} – Autoregressive Sieve Bootstrap.
#'   \item \code{\link{summary.boodd}} – Summary for objects of class boodd.
#'   \item \code{\link{tboot_dist}} – t-bootstrap distribution.
#'   \item \code{\link{pkc}} – Plot Kernel density.
#'   \item \code{\link{compute_power}} – Compute the power of the test.
#'   \item \code{\link{bopt_circy}} – Optimal choice of bootstrap block length for PC-process.
#'   \item \code{\link{genMM1}} – Generate the queuing system process.
#'   \item \code{\link{genETARCH}} – Generate the ETAR-ARCH process.
#' }
#'
#' @author
#' Patrice Bertail \email{patrice.bertail@parisnanterre.fr} \cr
#' University Paris Nanterre – Modal'X \cr \cr
#'
#' Bernard Desgraupes \cr
#' University Paris Nanterre – Modal'X \cr \cr
#'
#' Anna Dudek \cr
#' Department of Applied Mathematics \cr
#' AGH University of Krakow, Poland \cr \cr
#'
#' Karolina Marek \email{karolina.marek10@gmail.com} \cr
#' Department of Applied Mathematics \cr
#' AGH University of Krakow, Poland
#'
#' @references
#' P. Bertail and A. Dudek (2025),
#' *Bootstrap for Dependent Data, with an R package (by Bernard Desgraupes and Karolina Marek)* – submitted.
#'
#' @keywords package
#' @docType package
#' @name boodd
#' @aliases boodd-package
"_PACKAGE"
