% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{boilerplate_results}
\alias{boilerplate_results}
\title{Access Results from Unified Database}
\usage{
boilerplate_results(unified_db, name = NULL)
}
\arguments{
\item{unified_db}{List. The unified boilerplate database}

\item{name}{Character. Optional specific result section to retrieve (supports dot notation)}
}
\value{
List or character. The requested results database or specific section
}
\description{
This function extracts and returns the results portion of a unified database,
optionally retrieving a specific result section by name using dot notation.
}
\examples{
# Create a temporary directory and initialise database
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_results_example", "data")

# Initialise with default results
boilerplate_init(
  categories = "results",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import all databases
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Get all results sections
results_db <- boilerplate_results(unified_db)
names(results_db)

# Clean up
unlink(file.path(temp_dir, "boilerplate_results_example"), recursive = TRUE)

}
