% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migration-utilities.R
\name{boilerplate_migrate_to_json}
\alias{boilerplate_migrate_to_json}
\title{Migration Utilities for RDS to JSON Conversion}
\usage{
boilerplate_migrate_to_json(
  source_path,
  output_path,
  format = c("unified", "separate"),
  validate = TRUE,
  backup = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{source_path}{Path to directory containing RDS files or single RDS file}

\item{output_path}{Path where JSON files should be saved}

\item{format}{Output format: "unified" (single JSON) or "separate" (one per category)}

\item{validate}{Logical. Validate against JSON schema after conversion?
Default is TRUE.}

\item{backup}{Logical. Create backup of original files? Default is TRUE.}

\item{quiet}{Logical. Suppress progress messages? Default is FALSE.}
}
\value{
List with migration results containing:
\itemize{
\item \code{migrated}: Character vector of successfully migrated files
\item \code{errors}: List of any errors encountered during migration
\item \code{validation}: Validation results if validate=TRUE
}
}
\description{
Functions to help migrate from individual RDS files to unified JSON structure
Migrate boilerplate Database from RDS to JSON
}
\details{
Comprehensive migration tool that converts existing RDS-based boilerplate
databases to JSON format. Supports both unified (single file) and separate
(multiple files) output formats with optional schema validation.

The migration process:
\enumerate{
\item Scans source directory for RDS files
\item Creates timestamped backup if requested
\item Converts RDS to JSON format
\item Validates against schema if requested
\item Reports results and any issues
}

The "unified" format creates a single JSON file containing all categories,
which is recommended for version control and collaborative workflows.
}
\examples{
\donttest{
# Create temporary directories for example
source_dir <- tempfile()
output_dir <- tempfile()
dir.create(source_dir)
dir.create(output_dir)

# Create sample RDS file
sample_db <- list(
  name = "Example Measure",
  description = "An example for migration",
  items = c("item1", "item2")
)
saveRDS(sample_db, file.path(source_dir, "measures_db.rds"))

# Migrate from RDS to JSON
results <- boilerplate_migrate_to_json(
  source_path = source_dir,
  output_path = output_dir,
  format = "unified",
  validate = FALSE
)

# Check results
if (length(results$errors) == 0) {
  message("Migration successful!")
} else {
  print(results$errors)
}

# Clean up
unlink(source_dir, recursive = TRUE)
unlink(output_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_rds_to_json}}, \code{\link{validate_json_database}}
}
