% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init-functions.R
\name{boilerplate_init}
\alias{boilerplate_init}
\title{Initialise boilerplate Database}
\usage{
boilerplate_init(
  categories = c("measures", "methods", "results", "discussion", "appendix", "template"),
  merge_strategy = c("keep_existing", "merge_recursive", "overwrite_all"),
  data_path = NULL,
  quiet = FALSE,
  dry_run = FALSE,
  create_dirs = FALSE,
  confirm = TRUE,
  create_empty = TRUE,
  format = "json",
  project = "default"
)
}
\arguments{
\item{categories}{Character vector. Categories to include in the database.
Default is all categories: "measures", "methods", "results", "discussion", "appendix", "template".}

\item{merge_strategy}{Character. How to merge with existing databases: "keep_existing", "merge_recursive", or "overwrite_all".}

\item{data_path}{Character. Base path for data directory.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{dry_run}{Logical. If TRUE, simulates the operation without writing files. Default is FALSE.}

\item{create_dirs}{Logical. If TRUE, creates directories that don't exist. Default is FALSE.}

\item{confirm}{Logical. If TRUE, asks for confirmation before making changes. Default is TRUE.}

\item{create_empty}{Logical. If TRUE, creates empty database structures with just the template headings.
Default is TRUE. Set to FALSE to use default content.}

\item{format}{Character. Format to save: "json" (default), "rds", or "both".}

\item{project}{Character. Project name for organizing databases. Default is "default".
Projects are stored in separate subdirectories to allow multiple independent
boilerplate collections.}
}
\value{
Invisibly returns TRUE if successful.
}
\description{
This function initialises a boilerplate database. By default, it creates a single
unified JSON database containing all categories. Legacy support for separate RDS
files is maintained through the unified parameter.
}
\examples{
# Create a temporary directory for examples
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_example", "data")

# Initialise unified JSON database (new default)
boilerplate_init(
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = TRUE,
  confirm = FALSE,
  quiet = TRUE
)

# Check that unified JSON file was created
list.files(data_path)

# Initialise with default content in both formats
boilerplate_init(
  data_path = data_path,
  create_empty = FALSE,
  format = "both",
  confirm = FALSE,
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_example"), recursive = TRUE)

}
