% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.cluster.R
\name{create.cluster}
\alias{create.cluster}
\title{Create a Parallel Socket Cluster}
\usage{
create.cluster()
}
\value{
an object of class "cluster"
}
\description{
This function counts the number of cores of your computer processor and mount a parallel socket cluster. It always creates N-1 node to the cluster to let 1 core to the other tasks.
}
\examples{
\dontrun{
## Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("to your working directory")
# Load packages
library(bnpa)
# Use working data sets from package
data(dataQualiN)
# Start the cluster
cl <- bnpa::create.cluster()
# Set the number of replications
R=1000
# Set the algorithm to be used
algorithm="hc"
# Executes a parallel bootstrap process
data.bn.boot.strap=boot.strength(data=dataQualiN,R,algorithm,cluster=cl,
                                algorithm.args=list(score="bic"),cpdag = FALSE)
# Release the cluster
parallel::stopCluster(cl)
}
}
\references{
R Core Team (2019). R: A language and environment for statistical computing. R Foundation for Statistical Computing, Vienna, Austria. URL https://www.R-project.org/.
}
\author{
Elias Carvalho
}
