% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_bnns.R
\name{print.bnns}
\alias{print.bnns}
\title{Print Method for \code{"bnns"} Objects}
\usage{
\method{print}{bnns}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"bnns"}, typically the result of a call to \code{\link{bnns.default}}.}

\item{...}{Additional arguments (currently not used).}
}
\value{
The function is called for its side effects and does not return a value. It prints the following:
\itemize{
\item The function call used to generate the \code{"bnns"} object.
\item A summary of the Stan fit object stored in \code{x$fit}.
}
}
\description{
Displays a summary of a fitted Bayesian Neural Network (BNN) model, including the function call and the Stan fit details.
}
\examples{
\donttest{
# Example usage:
data <- data.frame(x1 = runif(10), x2 = runif(10), y = rnorm(10))
model <- bnns(y ~ -1 + x1 + x2,
  data = data, L = 1, nodes = 2, act_fn = 2,
  iter = 1e1, warmup = 5, chains = 1
)
print(model)
}
}
\seealso{
\code{\link{bnns}}, \code{\link{summary.bnns}}
}
