% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{flows_df}
\alias{flows_df}
\title{Extract the flow matrix from a spatial interaction model object in data frame
format}
\usage{
flows_df(sim, ...)
}
\arguments{
\item{sim}{a spatial interaction model object}

\item{...}{additional parameters (not used currently)}
}
\value{
a data frame of flows between origin locations and destination
locations with additional content if available (see Details).
}
\description{
Extract the flow matrix from a spatial interaction model object in data frame
format
}
\details{
This function extracts the flow matrix in a long format. Each row
contains the flow between an origin location and a destination location.
The resulting data frame has at least three columns:
\itemize{
\item \code{origin_idx}: identifies the origin location by its index from 1 to the number
of origin locations
\item \code{destination_idx}: identifies the destination location by its index from 1
to the number of destination locations
\item \code{flow}: the flow between the corresponding location
}

In addition, if location information is available, it will be included in
the data frame as follows:
\itemize{
\item location names are included using columns \code{origin_name} or \code{destination_name}
\item positions are included using 2 or 3 columns (per location type, origin or
destination) depending on the number of dimensions used for the location.
The names of the columns are by default \code{origin_x}, \code{origin_y} and
\code{origin_z} ( and equivalent names for destination location) unless
coordinate names are specified in the location positions. In this latter
case, the names are prefixed by \code{origin_} or \code{destination_}. For instance,
if the destination location position coordinates are named \code{"longitude"}
and \code{"latitude"}, the resulting columns will be \code{destination_longitude} and
\code{destination_latitude}.
}
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- log(french_cities$population[1:10])
attractiveness <- log(french_cities$area[1:10])
## rescale to production
attractiveness <- attractiveness / sum(attractiveness) * sum(production)
## simple case (no positions and default names)
model <- static_blvim(distances, production, 1.5, 1 / 500, attractiveness)
head(flows_df(model))
## with location data
positions <- as.matrix(french_cities[1:10, c("th_longitude", "th_latitude")])
model <- static_blvim(distances, production, 1.5, 1 / 500, attractiveness,
  origin_data = list(positions = positions),
  destination_data = list(positions = positions)
)
head(flows_df(model))
## with names
origin_names(model) <- french_cities$name[1:10]
destination_names(model) <- french_cities$name[1:10]
head(flows_df(model))
}
\seealso{
\code{\link[=location_positions]{location_positions()}},  \code{\link[=location_names]{location_names()}}, \code{\link[=flows]{flows()}}
}
