% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{ltm_sim}
\alias{ltm_sim}
\title{Simulate LTM model}
\usage{
ltm_sim(ns, nk, ni, vmu, mPhi, mSigs, dsig, vd, alpha)
}
\arguments{
\item{ns}{number of times}

\item{nk}{number of covariates}

\item{ni}{number of series}

\item{vmu}{vector mu}

\item{mPhi}{phi diagonal matrix with the parameters}

\item{mSigs}{sigma eta vector}

\item{dsig}{general sigma}

\item{vd}{threshold parameter}

\item{alpha}{intercept}
}
\value{
List containing the generated y, x, beta and thresholded beta.
}
\description{
Simulate LTM model using many
}
\examples{
# Generates 10 series, each one with 500 observations and 2 regressors.

d_sim <- ltm_sim(
  ns = 500, nk = 2, ni = 10,
  vmu = matrix(c(.5,.5), nrow = 2),
  mPhi = diag(2) * c(.99, .99),
  mSigs = c(.1,.1),
  dsig = .15,
  vd = matrix(c(.4,.4), nrow = 2),
  alpha = 0
)

str(d_sim)

}
\references{
Nakajima, Jouchi, and Mike West. "Bayesian analysis of latent threshold
dynamic models." Journal of Business & Economic
Statistics 31.2 (2013): 151-164.
}
