% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform-block.R, R/transform-fixed.R,
%   R/transform-head.R, R/transform-merge.R, R/transform-rbind.R,
%   R/transform-subset.R
\name{new_transform_block}
\alias{new_transform_block}
\alias{new_fixed_block}
\alias{new_head_block}
\alias{new_merge_block}
\alias{new_rbind_block}
\alias{new_subset_block}
\title{Transform block constructors}
\usage{
new_transform_block(server, ui, class, ctor = sys.parent(), ...)

new_fixed_block(expr, ...)

new_head_block(n = 6L, direction = c("head", "tail"), ...)

new_merge_block(by = character(), all_x = FALSE, all_y = FALSE, ...)

new_rbind_block(...)

new_subset_block(subset = "", select = "", ...)
}
\arguments{
\item{server}{A function returning \code{\link[shiny:moduleServer]{shiny::moduleServer()}}}

\item{ui}{A function with a single argument (\code{ns}) returning a \code{shiny.tag}}

\item{class}{Block subclass}

\item{ctor}{String-valued constructor name or function/frame number (mostly
for internal use or when defining constructors for virtual classes)}

\item{...}{Forwarded to \code{new_transform_block()} and \code{\link[=new_block]{new_block()}}}

\item{expr}{Quoted expression}

\item{n}{Number of rows}

\item{direction}{Either "head" or "tail"}

\item{by}{Column(s) tp join on}

\item{all_x, all_y}{Join type, see \code{\link[base:merge]{base::merge()}}}

\item{subset, select}{Expressions (passed as strings)}
}
\value{
All blocks constructed via \code{new_transform_block()} inherit from
\code{transform_block}.
}
\description{
Many data transformations are be provided by blocks constructed via
\code{new_transform_block()}, including examples where a single \code{data.frame} is
transformed into another (e.g. \code{subset_block}), and two or more \code{data.frame}s
are combined (e.g. \code{merge_block} or \code{rbind_block}).
}
\section{Fixed block}{

Mainly useful for testing and examples, this block applies a fixed
transformation to its data input. No UI elements are exposed and the
transformation consequently cannot be parametrized. The quoted expression
passed as \code{expr} is expected to refer to the input data as \code{data}.
}

\section{Head block}{

Row-subsetting the first or last \code{n} rows of a \code{data.frame} (as provided by
\code{\link[utils:head]{utils::head()}} and \code{\link[utils:head]{utils::tail()}}) is implemented as \code{head_block}. This is
an example of a block that takes a single \code{data.frame} as input and produces
a single \code{data.frame} as output.
}

\section{Merge block}{

Joining together two \code{data.frame}s, based on a set of index columns, using
\code{\link[base:merge]{base::merge()}} is available as \code{merge_block}. Depending on values passed
as \code{all_x}/\code{all_y} the result will correspond to an "inner", "outer", "left"
or "right" join. See \code{\link[base:merge]{base::merge()}} for details. This block class serves
as an example for a transform block that takes exactly two data inputs \code{x}
and \code{y} to produce a single \code{data.frame} as output.
}

\section{Row-bind block}{

Row-wise concatenation of an arbitrary number of \code{data.frame}s, as performed
by \code{\link[base:cbind]{base::rbind()}} is available as an \code{rbind_block}. This mainly serves as
an example for a variadic block via the "special" \code{...args} block data
argument.
}

\section{Subset block}{

This block allows to perform row and column subsetting on \code{data.frame}
objects via \code{\link[base:subset]{base::subset()}}. Using non-standard evaluation, strings passed
as \code{subset}/\code{select} arguments or entered via shiny UI are turned into
\code{language} objects by \code{\link[base:parse]{base::parse()}}.
}

