% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board-server.R
\name{board_server}
\alias{board_server}
\alias{board_server.board}
\title{Board server}
\usage{
board_server(id, x, ...)

\method{board_server}{board}(
  id,
  x,
  plugins = board_plugins(x),
  options = board_options(x),
  callbacks = list(),
  callback_location = c("end", "start"),
  ...
)
}
\arguments{
\item{id}{Parent namespace}

\item{x}{Board}

\item{...}{Generic consistency}

\item{plugins}{Board plugins as modules}

\item{options}{Board options (\code{NULL} defaults to the union of board, block
and registry sourced options)}

\item{callbacks}{Single (or list of) callback function(s), called only
for their side-effects)}

\item{callback_location}{Location of callback invocation (before or after
plugins)}
}
\value{
A \code{board_server()} implementation (such as the default for the
\code{board} base class) is expected to return a \code{\link[shiny:moduleServer]{shiny::moduleServer()}}.
}
\description{
A call to \code{board_server()}, dispatched on objects inheriting from \code{board},
returns a \code{\link[shiny:moduleServer]{shiny::moduleServer()}}, containing all necessary logic to
manipulate board components via UI. Extensibility over currently available
functionality is provided in the form of S3, where a \code{board_server()}
implementation of \code{board} sub-classes may be provided, as well as via a
plugin architecture and callback functions which can be used to register
additional observers.
}
